/*-------------------------------------------------------------------------------------*\
|  Joystick Functions Class								|
|  Adam Honse, Dec. 10 2009								|
|											|
|  Derived from a tutorial at								|
|  http://coding.derkeiler.com/Archive/General/comp.programming/2007-05/msg00480.html 	|
|											|
|  Provides common functions to access joysticks and gamepads				|
|  with a simple class implementation							|
|											|
|  This is open source, feel free to reuse it in your apps :)				|
\*-------------------------------------------------------------------------------------*/

#include <iostream>
#include <linux/joystick.h>
#include <string>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>
#define MAX_AXIS 16
#define MAX_BUTTONS 32

using namespace std;

/*-------------------------------------------------------------*\
|  Joystick class initializes with device name string		|
|  Must run Joystick::update() before polling to update status	|
|  poll_axis and poll_button return position of given axis or	|
|  button using aPos and bPos arrays				|
|  Joystick::get_name() returns the name of a USB joystick	|
|  To check if an update caused a change, use Joystick::changed |
\*-------------------------------------------------------------*/

class Joystick
{
public:
  Joystick(string dev);
  ~Joystick();
  void update();
  int poll_axis(int ax);
  int poll_button(int bt);
  string get_name();
  bool has_changed();
private:
  string device;
  unsigned char axisCount;
  unsigned char buttonCount;
  string padname;
  int fd;
  int aPos[MAX_AXIS];
  int bPos[MAX_BUTTONS];
  bool changed;
  js_event ev;
};
